% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pwr.R
\name{Pwr.lme}
\alias{Pwr.lme}
\title{Performs power calculations for an \code{lme} object}
\usage{
\method{Pwr}{lme}(
  object,
  ...,
  type = c("sequential", "marginal"),
  Terms,
  L,
  verbose = FALSE,
  ddf = numeric(0),
  alpha = 0.05,
  altB = NULL,
  tol = 1e-10
)
}
\arguments{
\item{object}{an \code{\link[nlme:lme]{lme}} object containing a model fit, which provides information needed for power calculations.}

\item{\dots}{some additional arguments may be required.}

\item{type}{an optional character string specifying the type of sum of squares to be used in F-tests 
needed for power calculations. Syntax is the same as for \code{\link[nlme:anova.lme]{anova.lme}} in the \code{nlme} package.}

\item{Terms}{an optional integer or character vector specifying which terms
in the model should be jointly tested to be zero using a Wald F-test. See
\code{\link[nlme:anova.lme]{anova.lme}} in the \code{nlme} package for details.}

\item{L}{an optional numeric vector or array specifying linear combinations
of the coefficients in the model that should be tested to be zero. See
\code{\link[nlme:anova.lme]{anova.lme}} in the \code{nlme} package for details.}

\item{verbose}{logical. If \code{TRUE}, additional information is provided. See \code{\link[nlme:anova.lme]{anova.lme}} in the \code{nlme} package for details.}

\item{ddf}{numeric scalar value. Redefines the default number of denominator degrees of freedom.}

\item{alpha}{numeric scalar value. By default, \code{0.05}.}

\item{altB}{matrix or vector containing alternative values for beta parameters.}

\item{tol}{numeric scalar value for numerical tolerance.}
}
\value{
A data frame inheriting from class \code{Pwr.lme}.
}
\description{
This is a method for the \code{\link{Pwr}} generic function. It works for the
example given in Galecki and Burzykowski (2013) but may require additional testing,
especially for post-hoc power analysis.
}
\references{
Galecki, A., & Burzykowski, T. (2013). *Linear Mixed-Effects Models: A Step-by-Step Approach*. Springer.
}
\seealso{
\code{\link[nlme:anova.lme]{anova.lme}}
}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
