% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk_lakes.R
\name{crosswalk_lake_id}
\alias{crosswalk_lake_id}
\alias{nhdhr_to_local}
\alias{local_to_nhdhr}
\alias{nhdhr_to_comid}
\alias{comid_to_nhdhr}
\alias{nhdhr_to_nhd}
\alias{nhd_to_nhdhr}
\alias{nhdhr_to_lagos}
\alias{lagos_to_nhdhr}
\alias{nhdhr_to_mglp}
\alias{mglp_to_nhdhr}
\alias{comid_to_nhd}
\alias{nhd_to_comid}
\alias{comid_to_lagos}
\alias{lagos_to_comid}
\alias{comid_to_mglp}
\alias{mglp_to_comid}
\alias{comid_to_local}
\alias{local_to_comid}
\alias{nhd_to_lagos}
\alias{lagos_to_nhd}
\alias{nhd_to_mglp}
\alias{mglp_to_nhd}
\alias{nhd_to_local}
\alias{local_to_nhd}
\alias{lagos_to_mglp}
\alias{mglp_to_lagos}
\alias{lagos_to_local}
\alias{local_to_lagos}
\alias{mglp_to_local}
\alias{local_to_mglp}
\title{Crosswalk from one lake ID to another}
\usage{
nhdhr_to_local(
  data,
  from_colname = "nhdhr.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

local_to_nhdhr(
  data,
  from_colname,
  states = NULL,
  agency = NULL,
  id_field = NULL
)

nhdhr_to_comid(data, from_colname = "nhdhr.id")

comid_to_nhdhr(data, from_colname = "nhd.comid")

nhdhr_to_nhd(data, from_colname = "nhdhr.id")

nhd_to_nhdhr(data, from_colname = "nhd.id")

nhdhr_to_lagos(data, from_colname = "nhdhr.id")

lagos_to_nhdhr(data, from_colname = "lagos.id")

nhdhr_to_mglp(data, from_colname = "nhdhr.id")

mglp_to_nhdhr(data, from_colname = "mglp.id")

comid_to_nhd(data, from_colname = "nhd.comid")

nhd_to_comid(data, from_colname = "nhd.id")

comid_to_lagos(data, from_colname = "nhd.comid")

lagos_to_comid(data, from_colname = "lagos.id")

comid_to_mglp(data, from_colname = "nhd.comid")

mglp_to_comid(data, from_colname = "mglp.id")

comid_to_local(
  data,
  from_colname = "nhd.comid",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

local_to_comid(
  data,
  from_colname,
  states = NULL,
  agency = NULL,
  id_field = NULL
)

nhd_to_lagos(data, from_colname = "nhd.id")

lagos_to_nhd(data, from_colname = "lagos.id")

nhd_to_mglp(data, from_colname = "nhd.id")

mglp_to_nhd(data, from_colname = "mglp.id")

nhd_to_local(
  data,
  from_colname = "nhd.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

local_to_nhd(data, from_colname, states = NULL, agency = NULL, id_field = NULL)

lagos_to_mglp(data, from_colname = "lagos.id")

mglp_to_lagos(data, from_colname = "mglp.id")

lagos_to_local(
  data,
  from_colname = "lagos.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

local_to_lagos(
  data,
  from_colname,
  states = NULL,
  agency = NULL,
  id_field = NULL
)

mglp_to_local(
  data,
  from_colname = "mglp.id",
  states = NULL,
  agency = NULL,
  id_field = NULL
)

local_to_mglp(
  data,
  from_colname,
  states = NULL,
  agency = NULL,
  id_field = NULL
)

crosswalk_lake_id(
  data,
  from,
  to,
  from_colname,
  states = NULL,
  agency = NULL,
  id_field = NULL
)
}
\arguments{
\item{data}{A data.set with a column containing a lake identifier
corresponding to one of the datasets listed above (also see lake_id_xref)}

\item{from_colname}{Character. The column name in \code{data} that lake IDs
that are being converted from (e.g. \code{data} has a lake ID column that
you are trying to convert from -- what is the name of that column)}

\item{states}{Character. The two digit state abbreviation in lower case (
i.e. "wi", "mn", "mi", etc.). This will filter the crosswalk table to only
the states listed in this argument.}

\item{agency}{Optional character vector specifying the agency to use for
the local ID column. This is helpful if data exist in lake_id_xref for
which there are more than one agency in a state that provided data}

\item{id_field}{Optional character vector specifying the id.field to use
for the local ID column. Occasionally states use more than one identifier.
This allows explicit choice of which identifier to use.}

\item{from}{Character. The name of the lake ID field from lake_id_xref that
you want to reference from}

\item{to}{Character. The name of the lake ID field from lake_id_xref that
you want to reference to}
}
\value{
A data.frame the same as \code{data}, but with an additional
lake identification column from lake_id_xref
}
\description{
These are functions to be able to quickly and easily translate data.frames
of lake data in the Midwest from one identifier ot another. IDs are from
national, regianal, and state data.sets; these include National Hydrography
Dataset (NHD), NHD Plus High Resolution (NHDHR), LAke multi-scaled
GeOSpatial and temporal database (LAGOS), the Midwest Glacial Lakes
Partnership (MGLP), and state resource management and/or geography/mapping
agencies. Local state agency lake IDs are housed under the column
\code{local.id} in \code{\link{lake_id_xref}} and correspond to the state
in which they reside and the agency that provided the data in those
respective columns.
}
\examples{
local_to_nhdhr(wis_lakes, from_colname = "lake.id", states = "wi")
}
