% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\docType{data}
\name{newws}
\alias{newws}
\title{NEWWS Riverside data}
\value{
A list containing
\item{treat}{Treatment is a binary variable, taking the value of 1 if a participant was assigned to LFA and 0 otherwise}
\item{emp}{Mediator is a binary variable, taking the value of 1 if one was ever employed during the two-year period after randomization and 0 if not.}
\item{depression}{Outcome, maternal depression at the end of the second year after randomization, is a summary score of 12 items measuring depressive symptoms during the past week on a 0-3 scale.}
\item{nevmar}{1 if never married and 0 otherwise.}
\item{emp_prior}{1 if employed and 0 otherwise.}
\item{hispanic}{1 if Hispanic and 0 otherwise.}
\item{CHCNT}{1 if had 1 child, 2 if had 2 children, and 3 if had 3 or more children before randomization.}
\item{ADCPC}{welfare amount in the year before randomization}
\item{attitude}{a composite score of two attitude items - so many family problems that I cannot work at a full time or part time job; so much to do during the day that I cannot go to a school or job training program - measured on the scale of 1-4.}
\item{depress_prior}{a composite score of three depressive symptom items - sad, depressed, blues, and lonely - in the week before randomization measured on the scale of 1-4.}
\item{workpref}{one's level of preference for taking care of family full time than working on the scale of 1-4.}
\item{nohsdip}{1 if had never obtained a high school diploma or a General Educational Development certificate and 0 otherwise.}
}
\description{
The National Evaluation of Welfare-to-Work Strategies (NEWWS) was conducted before the nationwide welfare reform in the mid-1990s. 
Participants of the study consist of applicants to the Aid to Families with Dependent Children (AFDC) program and current AFDC recipients who were not working for 30 or more hours per week. 
They were randomly assigned to the labor force attachment (LFA) program, which aimed at moving low-income parents from welfare to work by providing employment-focused incentives and services, and the control group, which received aid from AFDC without requirement for working. 
The data is from the Riverside sample. It includes 694 participants with preschool-age children, 208 randomly assigned to the LFA program and 486 randomly assigned to the control group. 
The National Evaluation of Welfare-to-Work Strategies (NEWWS) Riverside study.
}
