% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profit_thresholds.R
\name{profit_thresholds}
\alias{profit_thresholds}
\title{Find optimal threshold for churn prediction (class)}
\usage{
profit_thresholds(
  x,
  var_cost = 0,
  prob_accept = 1,
  tp_val = 0,
  fp_val = 0,
  tn_val = 0,
  fn_val = 0,
  prob_col = NA,
  truth_col = NA
)
}
\arguments{
\item{x}{A data frame containing predicted probabilities of a target event and the actual outcome/class.}

\item{var_cost}{Variable cost (e.g. of a campaign offer)}

\item{prob_accept}{Probability of offer being accepted. Defaults to 1.}

\item{tp_val}{The average value of a True Positive. `var_cost` is automatically subtracted.}

\item{fp_val}{The average cost of a False Positive. `var_cost` is automatically subtracted.}

\item{tn_val}{The average value of a True Negative.}

\item{fn_val}{The average cost of a False Negative.}

\item{prob_col}{The unquoted name of the column with probabilities of the event of interest.}

\item{truth_col}{The unquoted name of the column with the actual outcome/class. Possible values are 'Yes' and 'No'.

#' @return
A data frame with the following columns:

threshold = prediction thresholds \cr
payoff    = calculated profit for each threshold}
}
\description{
Finds the optimal threshold (from a business perspective) for classifying churners.
}
\examples{
profit_thresholds(predictions,
   var_cost    = 100,
   prob_accept = .8,
   tp_val      = 2000,
   fp_val      = 0,
   tn_val      = 0,
   fn_val      = -2000,
   prob_col    = Yes,
   truth_col   = Churn)
}
