% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{HZ}
\alias{HZ}
\title{Statistic of the Henze-Zirkler test}
\usage{
HZ(data)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}
}
\value{
value of the test statistic.
}
\description{
This function returns the value of the statistic of the \code{\link{BHEP}} test as in Henze and Zirkler (1990). The difference to the \code{\link{BHEP}} test is in the choice of the tuning parameter \eqn{\beta}.
}
\details{
A \code{\link{BHEP}} test is performed with tuning parameter \eqn{\beta} chosen in dependence of the sample size n and the dimension d, namely \deqn{\beta=\frac{((2d+1)n/4)^(1/(d+4))}{\sqrt{2}}.}
}
\examples{
HZ(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Henze, N., and Zirkler, B. (1990), A class of invariant consistent tests for multivariate normality, Commun.-Statist. – Th. Meth., 19:3595–3617, \href{https://doi.org/10.1080/03610929008830400}{DOI}
}
\seealso{
\code{\link{BHEP}}
}
