% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rlibs.R
\name{pkglist}
\alias{pkglist}
\alias{modules}
\alias{Rlibs}
\alias{modlist}
\title{Extract \code{library} and \code{require} calls in R and \code{import} calls from Python}
\usage{
pkglist(files, code = TRUE, repos = getOption("repos"))

Rlibs(files, code = TRUE, repos = getOption("repos"))

modlist(files, code = TRUE, repos = getOption("repos"))
}
\arguments{
\item{files}{character: file name(s)}

\item{code}{logical: should names given back or code for init scrips? (default: \code{TRUE})}

\item{repos}{character: the base URL(s) of the repositories to use (default: \code{getoption("repos")})}
}
\value{
a table how frequently the packages are called or R Code to install them
}
\description{
\code{pkglist} counts the number of \code{library}/\code{require}/\code{import} calls for R and Python commands in the files.
If you set \code{code==TRUE} then returns R code for installing packages/modules.
It checks via \code{\link[utils:available.packages]{utils::available.packages()}} (for R) and via \code{PyPI} if a package/module is available.
Otherwise a table with the number of \code{library} or \code{import} is returned.
}
\examples{
if (interactive()) {
  files <- list.files(pattern="*.(R|py)$", full.names=TRUE, recursive=TRUE)
  pkglist(files)
}
}
