% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureFairnessComposite.R
\name{MeasureFairnessComposite}
\alias{MeasureFairnessComposite}
\title{Composite Fairness Measure}
\description{
Computes a composite measure from multiple fairness metrics and aggregates them
using \code{aggfun} (defaulting to \code{\link[=mean]{mean()}}).
}
\section{Protected Attributes}{

The protected attribute is specified as a \code{col_role} in the corresponding \code{\link[mlr3:Task]{mlr3::Task()}}:\cr
\verb{<Task>$col_roles$pta = "name_of_attribute"} \cr
This also allows specifying more than one protected attribute,
in which case fairness will be considered on the level of intersecting groups defined by all columns
selected as a predicted attribute.
}

\examples{
library("mlr3")
# Equalized Odds Metric
MeasureFairnessComposite$new(measures = msrs(c("fairness.fpr", "fairness.tpr")))

# Other metrics e.g. based on negative rates
MeasureFairnessComposite$new(measures = msrs(c("fairness.fnr", "fairness.tnr")))
}
\section{Super class}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{MeasureFairnessComposite}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureFairnessComposite-new}{\code{MeasureFairnessComposite$new()}}
\item \href{#method-MeasureFairnessComposite-clone}{\code{MeasureFairnessComposite$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureFairnessComposite-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureFairnessComposite-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureFairnessComposite$new(
  id = NULL,
  measures,
  aggfun = function(x) mean(x),
  operation = groupdiff_absdiff,
  minimize = TRUE,
  range = c(-Inf, Inf)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Id of the measure. Defaults to the concatenation of ids in \code{measure}.}

\item{\code{measures}}{(list of \link{MeasureFairness})\cr
List of fairness measures to aggregate.}

\item{\code{aggfun}}{(\verb{function()})\cr
Aggregation function used to aggregate results from respective measures. Defaults to \code{sum}.}

\item{\code{operation}}{(\verb{function()})\cr
The operation used to compute the difference. A function that returns
a single value given input: computed metric for each subgroup.
Defaults to \code{groupdiff_absdiff}.
See \code{MeasureFairness} for more information.}

\item{\code{minimize}}{(\code{logical(1)})\cr
Should the measure be minimized? Defaults to \code{TRUE}.}

\item{\code{range}}{(\code{numeric(2)})\cr
Range of the resulting measure. Defaults to \code{c(-Inf, Inf)}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureFairnessComposite-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureFairnessComposite-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureFairnessComposite$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
