% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{mp_sensitivity}
\alias{mp_sensitivity}
\title{Run power sensitivity analysis over a parameter grid}
\usage{
mp_sensitivity(
  scenario,
  vary,
  nsim = 100,
  alpha = 0.05,
  seed = NULL,
  failure_policy = c("count_as_nondetect", "exclude"),
  conf_level = 0.95
)
}
\arguments{
\item{scenario}{A base \code{mp_scenario} object.}

\item{vary}{Named list of vectors. Names are dotted paths such as
\code{"fixed_effects.condition"} or \code{"clusters.subject"}.}

\item{nsim}{Number of simulations for each grid cell.}

\item{alpha}{Significance threshold.}

\item{seed}{Optional seed for reproducible cell-wise execution.}

\item{failure_policy}{Failure policy passed to \code{\link[=mp_power]{mp_power()}}.}

\item{conf_level}{Confidence level passed to \code{\link[=mp_power]{mp_power()}}.}
}
\value{
An object of class \code{mp_sensitivity}.
}
\description{
Run power sensitivity analysis over a parameter grid
}
