% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario.R
\name{mp_scenario}
\alias{mp_scenario}
\title{Create a power-analysis scenario}
\usage{
mp_scenario(
  formula,
  design,
  assumptions,
  test = c("wald", "lrt", "custom"),
  simulate_fun = NULL,
  fit_fun = NULL,
  test_fun = NULL,
  notes = NULL
)
}
\arguments{
\item{formula}{A model formula (stored for later backends).}

\item{design}{An \code{mp_design}.}

\item{assumptions}{An \code{mp_assumptions}.}

\item{test}{Character string or list identifying the test type (metadata).}

\item{simulate_fun}{Function or NULL.}

\item{fit_fun}{Function or NULL.}

\item{test_fun}{Function or NULL.}

\item{notes}{Optional free text.}
}
\value{
An object of class \code{mp_scenario}.
}
\description{
A scenario combines: (1) a design, (2) assumptions, (3) a model specification,
and (4) an analysis engine.
}
\details{
In Phase 1, the engine is \emph{pluggable} via three functions:
\itemize{
\item \code{simulate_fun(scenario, seed)} returns a data.frame
\item \code{fit_fun(data, scenario)} returns a fit object
\item \code{test_fun(fit, scenario)} returns a list with at least \code{p_value} (numeric scalar)
}

This allows \code{mp_power()} to run before selecting a specific backend (e.g., lme4).
}
\examples{
d <- mp_design(list(subject = 20), trials_per_cell = 5)
a <- mp_assumptions(list(condition = 0.3), residual_sd = 1)
s <- mp_scenario(y ~ condition, d, a, test = "wald")
s
}
