% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_fmi.R
\name{fmi}
\alias{fmi}
\title{Fowlkes-Mallows Index}
\usage{
fmi(data = NULL, obs, pred, pos_level = 2, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Fowlkes-Mallows Index for a nominal/categorical
predicted-observed dataset.
}
\details{
The fmi has gained popularity within the machine learning community
to summarize into a single value the confusion matrix of a binary classification.
It is particularly useful when the number of observations belonging to each class
is uneven or imbalanced. It is characterized for being symmetric (i.e. no class
has more relevance than the other). It is bounded between -1 and 1.
The closer to 1 the better the classification performance.

The fmi is only available for the evaluation of binary cases (two classes). For
multiclass cases, fmi will produce a \code{NA} and display a warning.

For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Get fmi estimate for two-class case
fmi(data = binomial_case, obs = labels, pred = predictions)
}
}
\references{
Fowlkes, Edward B; Mallows, Colin L (1983).
A method for comparing two hierarchical clusterings.
\emph{Journal of the American Statistical Association. 78 (383): 553–569.}
\doi{10.1080/01621459.1983.10478008}
}
