% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_SDSD.R
\name{SDSD}
\alias{SDSD}
\title{Squared difference between standard deviations (SDSD)}
\usage{
SDSD(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the SDSD component of the Mean Squared Error (MSE)
proposed by Kobayashi & Salam (2000).
}
\details{
The SDSD represents the proportional bias component of the prediction error
following Kobayashi & Salam (2000). It is in square units of the variable of interest, so
it does not have a direct interpretation. The lower the value the less contribution to the MSE.
However, it needs to be compared to MSE as its benchmark.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
SDSD(obs = X, pred = Y)
}
}
\references{
Kobayashi & Salam (2000).
Comparing simulated and measured values using mean squared deviation and its components.
\emph{Agron. J. 92, 345–352.} \doi{10.2134/agronj2000.922345x}
}
