% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacore.R
\name{get_control_term}
\alias{get_control_term}
\title{Get Control Term}
\usage{
get_control_term(metacode, variable, dataset = NULL)
}
\arguments{
\item{metacode}{metacore object}

\item{variable}{A variable name to get the controlled terms for. This can
either be a string or just the name of the variable}

\item{dataset}{A dataset name. This is not required if there is only one set
of control terminology across all datasets}
}
\value{
a vector for permitted values and a 2-column tibble for codelists
}
\description{
Returns the control term (a vector for permitted values and a tibble for code
lists) for a given variable. The dataset can be optionally specified if there
is different control terminology for different datasets
}
\examples{
\dontrun{
meta_ex <- spec_to_metacore(metacore_example("p21_mock.xlsx"))
get_control_term(meta_ex, QVAL, SUPPAE)
get_control_term(meta_ex, "QVAL", "SUPPAE")
}
}
