% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SDp_from_SD}
\alias{SDp_from_SD}
\title{Pooled Standard Deviation from Two Standard Deviations}
\usage{
SDp_from_SD(SD1, SD2, n1 = NA, n2 = NA, method = "hedges")
}
\arguments{
\item{SD1}{standard deviation of group 1}

\item{SD2}{standard deviation of group 2}

\item{n1}{sample size of group 1}

\item{n2}{sample size of group 2}

\item{method}{the method ("hedges", "cohen") that should be used to calculate the SD. Method "hedges" requires sample sizes.
The "cohen" method uses a simplified method by and does not rely on sample sizes.}
}
\value{
Pooled standard deviation
}
\description{
Calculates the pooled standard deviation.
}
\details{
The method according to Hedges requires the sample sizes. If only standard deviations are available, the simpler equation provided by Cohen (1988) can be used. If there are more than two groups, \code{\link[=SD_M_n_pooled_from_groups]{SD_M_n_pooled_from_groups()}} should be used.
Note: The use of the names "Cohen" and "Hedges" for the methods can be inconsistent in the literature. It is somewhat unusual because Cohen (1977) outlined both estimators for the pooled standard deviation before Hedges (1981) discussed them.
}
\examples{
# Standard deviation according to Cohen:
SDp_from_SD(2, 3, method = "cohen")

# Standard deviation according to Hedges needs sample sizes:
SDp_from_SD(2, 3, 50, 50)
}
\references{
Borenstein, M., Hedges, L.V., Higgins, J.P.T. and Rothstein, H.R. (2009). Converting Among Effect Sizes. In Introduction to Meta-Analysis (eds M. Borenstein, L.V. Hedges, J.P.T. Higgins and H.R. Rothstein). https://doi.org/10.1002/9780470743386.ch7

Cohen, J. (1977). Statistical power analysis for the behavioral sciences (2nd ed.). Hillsdale, NJ, US: Lawrence Erlbaum Associates, Inc.

Ellis, P.D. (2009), "Effect size equations". \href{https://www.psychometrica.de/effect_size.html}{Link}

Hedges, L. V. (1981). Distribution theory for Glass's estimator of effect size and related estimators.
Journal of Educational Statistics, 6, 107-128.

Difference between Cohen's d and Hedges' g for effect size metrics. Stackoverflow. \href{https://stats.stackexchange.com/q/338043}{Link}
}
\seealso{
\code{\link[=SD_within_from_SD_r]{SD_within_from_SD_r()}} for matched groups
}
