% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_vector.R
\name{scale_mag}
\alias{scale_mag}
\alias{scale_mag_continuous}
\title{Scale for vector magnitudes}
\usage{
scale_mag(
  name = ggplot2::waiver(),
  n.breaks = 1,
  breaks = ggplot2::waiver(),
  oob = no_censor,
  ...
)

scale_mag_continuous(
  name = ggplot2::waiver(),
  n.breaks = 1,
  breaks = ggplot2::waiver(),
  oob = no_censor,
  ...
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{n.breaks}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{...}{Other arguments passed on to \verb{scale_(x|y)_continuous()}}
}
\description{
Allows to control the size of the arrows in \link{geom_arrow}.
Highly experimental.
}
\examples{
library(ggplot2)
g <- ggplot(seals, aes(long, lat)) +
    geom_vector(aes(dx = delta_long, dy = delta_lat), skip = 2)

g + scale_mag("Seals velocity")

g + scale_mag("Seals velocity", limits = c(0, 1))

}
