% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_utilities.R
\name{read_utilities}
\alias{read_utilities}
\title{Read utilities}
\usage{
read_utilities(file, lines, skip = 2, encoding = "utf-8", envir = .GlobalEnv)
}
\arguments{
\item{file}{standardize file with definitions.}

\item{lines}{number lines to read in \code{file}.}

\item{skip}{to read the \code{file} it had to \code{skip} a given number of lines.}

\item{encoding}{file encoding.}

\item{envir}{environment where utility functions will be created.}
}
\value{
Returns data table with definition of utility functions by range.
}
\description{
Builds utility functions from definition standard.
}
\details{
The basic MAUT models are built with functions of constant absolute risk aversion, 
this functions could be defined with simple parameters, only is necessary a function name and
the domain of definition of every function and more important is necessary no more than three
coefficients for the function definition.
}
\examples{
library( data.table )
file <- system.file("extdata", "utilities.txt", package = "mau" )
lines <- 17
skip <- 2
encoding <- 'utf-8'
functions <- read_utilities( file, lines, skip, encoding )
}
\seealso{
\code{\link{stand_string}}
}
\author{
Pedro Guarderas, Andrés Lopez
}
