% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_matrix}
\alias{import_matrix}
\title{This function imports a matrix (data frame) from various file formats (CSV, TSV, RDS, XLSX, XLS, TXT) and ensures it contains the required columns.
It also allows the user to control whether extra columns should be dropped or kept.}
\usage{
import_matrix(
  path,
  format = NULL,
  drop_extra = FALSE,
  extra_columns = NULL,
  remove_dups = TRUE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{path}{A character string specifying the path to the file to be imported.}

\item{format}{A character string specifying the file format. If not provided, the format is automatically detected based on the file extension.
Supported formats: "csv", "tsv", "rds", "xlsx", "xls", "txt".}

\item{drop_extra}{A logical value indicating whether extra columns (not in the list of required columns) should be dropped. Default is `FALSE`.}

\item{extra_columns}{A character vector of column names that are allowed in addition to the required columns. By default, no extra columns are allowed.}

\item{remove_dups}{A logical value indicating whether to remove duplicate columns before merging. Default is `TRUE`.}

\item{silent}{A logical value indicating whether to suppress messages. Default is `FALSE`.}

\item{...}{Additional arguments passed to the specific file-reading functions (e.g., `read.csv`, `read.delim`, `readRDS`, `readxl::read_xlsx`, `readxl::read_xls`, `read.table`).
Refer to the documentation of the corresponding read function for the list of valid arguments.}
}
\value{
A data frame containing the imported matrix, with the required columns and any allowed extra columns.
}
\description{
This function imports a matrix (data frame) from various file formats (CSV, TSV, RDS, XLSX, XLS, TXT) and ensures it contains the required columns.
It also allows the user to control whether extra columns should be dropped or kept.
}
\details{
The matrix includes the following predefined columns:

- `year`: Numeric. Year of publication.
- `citation`: Character. Citation or reference details.
- `keywords`: Character. Keywords or tags for the study.
- `profession`: Character. Profession of the study participants or target audience.
- `electronic`: Logical. Indicates whether the study is available electronically.
- `purpose`: Character. Purpose or objective of the study.
- `study_design`: Character. Study design or methodology.
- `outcome_var`: Character. Outcome variables measured in the study.
- `predictor_var`: Character. Predictor variables considered in the study.
- `sample`: Numeric. Sample size.
- `dropout_rate`: Numeric. Dropout or attrition rate.
- `setting`: Character. Study setting (e.g., clinical, educational).
- `inclusion_criteria`: Character. Inclusion criteria for participants.
- `ethnicity`: Character. Ethnic background of participants.
- `age`: Numeric. Age of participants.
- `sex`: Factor. Sex of participants.
- `income`: Factor. Income level of participants.
- `education`: Character. Educational background of participants.
- `measures`: Character. Measures or instruments used for data collection.
- `analysis`: Character. Analytical methods used.
- `results`: Character. Summary of results or findings.
- `limitations`: Character. Limitations of the study.
- `implications`: Character. Implications or recommendations from the study.
- `ethical_concerns`: Character. Ethical concerns addressed in the study.
- `biases`: Character. Potential biases in the study.
- `notes`: Character. Additional notes or observations.

Extra columns beyond the required ones are handled via the `extra_columns` argument. If the `drop_extra` argument is set to `TRUE`,
extra columns will be removed. If `drop_extra` is `FALSE`, extra columns will remain in the imported data, and a message will be shown.

The `...` argument allows you to pass additional parameters directly to the read functions. For instance:
- For `read.csv`, `...` could include `header = TRUE`, `sep = ","`, or `stringsAsFactors = FALSE`.
- For `read.delim`, `...` could include `header = TRUE`, `sep `, or `stringsAsFactors = FALSE`.
- For `readRDS`, `...` could include `refhook = NULL`.
- For `readxl::read_xlsx`, `...` could include `sheet = 1` or `col_names = TRUE`.
- For `readxl::read_xls`, `...` could include `sheet = 1` or `col_Names = TRUE`.
- For `read.table`, `...` could include `header = TRUE`, `sep`, or `stringsAsFactors = FALSE`.
}
