% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta.R
\name{eta}
\alias{eta}
\title{Generate a vector of "ETA"}
\usage{
eta(x, ..., n, val = 0)
}
\arguments{
\item{x}{either a \code{mrgsolve} model object, or a numeric}

\item{...}{additional numeric(s)}

\item{n, val}{generate a sequence of \code{val} of length \code{n}}
}
\value{
a single named vector of numeric
}
\description{
Generate a vector of "ETA" values. If x is a \code{mrgsolve} model, these will be extracted from values defined in \verb{$PARAM}. Otherwise, any numeric values passed to \code{x} and \code{...} as vector(s) or list(s) will be coerced as a single vector. Alternatively, if \code{x} and \code{...} are missing, generate a vector of ETA equal to \code{val} of length \code{n}.
}
\examples{
# Extract ETA from the model
mod <- exmodel()
eta(mod)

# Coerce numeric values
eta(0.1, 0.2, c(0.3, 0.4), list(0.5, 0.6))
eta(rnorm(4))

# Generate a sequence from scratch
eta(n = 3)
eta(n = 3, val = 0.001)
}
