% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aad.R
\name{aad}
\alias{aad}
\title{Mean (average) absolute deviation from the mean}
\usage{
aad(x, na.rm = FALSE)
}
\arguments{
\item{x}{A vector containing the observations.}

\item{na.rm}{A logical value indicating whether or not missing values should be removed. Defaults to \code{FALSE}}
}
\value{
Numeric
}
\description{
Calculates the mean absolute deviation from the sample mean
}
\details{
The \code{aad} function calculates the average (i.e. mean)
absolute deviation from the mean value of \code{x}, removing \code{NA}
values if requested by the user. It exists primarily to simplify the
discussion of descriptive statistics during an introductory stats class.
}
\examples{
# basic usage
X <- c(1, 3, 6)  # data
aad(X)           # returns a value of 1.777

# removing missing data
X <- c(1, 3, NA, 6)   # data
aad(X)                # returns NA
aad(X, na.rm = TRUE)  # returns 1.777

}
