% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configurations.R
\name{set_logfile}
\alias{set_logfile}
\title{Set Log File}
\usage{
set_logfile(logfile = NULL, confirm = TRUE, create = TRUE)
}
\arguments{
\item{logfile}{Absolut or relative path to log file.
An attempt is made to convert the path into a canonical absolute form using \code{\link[=normalizePath]{normalizePath()}}.
If \code{NULL} will set to \verb{<tmpdir>/loggit.log}.}

\item{confirm}{Print confirmation of log file setting?}

\item{create}{Create the log file if it does not exist?}
}
\value{
Invisible the previous log file path.
}
\description{
Set the log file that loggit will write to by default.
}
\details{
No logs outside of a temporary directory will be written until this is set explicitly, as per CRAN policy.
Therefore, the default behavior is to create a file named \code{loggit.log} in your system's temporary directory.
}
\examples{
\dontrun{
  set_logfile("path/to/logfile.log")
}
}
