% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stat_adj_boxplot}
\alias{stat_adj_boxplot}
\alias{stat_adj_boxplot_outlier}
\title{Adjusted Boxplot Statistics for ggplot2}
\usage{
stat_adj_boxplot()

stat_adj_boxplot_outlier()
}
\description{
Computes adjusted boxplot statistics to be used by \code{ggplot2}.
See Hubert & Vandervieren (2008, p.5191, Eq.5).
}
\section{Functions}{
\itemize{
\item \code{stat_adj_boxplot_outlier()}: add outliers to adjusted boxplot

}}
\examples{
library(ggplot2)

d <- data.frame(x = gl(2, 50), y = rnorm(100))
ggplot(data = d, mapping = aes(x = x, y = y)) +
   stat_adj_boxplot()

}
\references{
Hubert, M., and E. Vandervieren, 2008.
An adjusted boxplot for skewed distributions.
Computational Statistics and Data Analysis 52:5186-5201
\doi{10.1016/j.csda.2007.11.008}
}
\seealso{
\code{\link{adj_boxplot_stats}}, \code{\link{stat_adj_boxplot_outlier}}
}
