% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_search.R
\name{gene_search}
\alias{gene_search}
\title{A function for Gene search}
\usage{
gene_search(
  input_item = "lmp_id",
  input_value,
  output_item,
  output_format = ""
)
}
\arguments{
\item{input_item}{choose input item from the following options: "lm_id", "formula","inchi_key","pubchem_cid","hmdb_id","kegg_id","chebi_id","smiles","abbrev","abbrev_chains"}

\item{input_value}{input the value you want to search}

\item{output_item}{select your output from following options:"all","classification","lm_id","name","sys_name","synonyms","core","main_class","sub_class","class_level4","exactmass","formula","inchi","inchi_key","kegg_id","hmdb_id","chebi_id","lipidbank_id","pubchem_cid","smiles","molfile","structure","physchem"}

\item{output_format}{select your output format from following options: "json (default)","text"}
}
\value{
The search results
}
\description{
A function for Gene search
}
\examples{

# Fetch all gene fields from gene symbol
gene_search("gene_symbol", "acaca", "all")

# Fetch gene name from Entrez gene id
gene_search("gene_id", "31", "gene_name")

}
\author{
Mingzhuo Tian \email{tianmingzhuo@outlook.com}
License: GPL (>= 3)
}
