% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setCurrentTime}
\alias{setCurrentTime}
\title{Adjust the time of the current time bar}
\usage{
setCurrentTime(id, time)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{time}{The new date/time}
}
\value{
None, side-effect is Javascript call
}
\description{
Adjust the time of the current time bar
}
\examples{
\dontrun{
linevis() \%>\%
  setCurrentTime(Sys.Date())
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Set current time to beginning of today")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$btn, {
      setCurrentTime("graph2d", Sys.Date())
    })
  }
)
}
}
