% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candles.R
\name{candles}
\alias{candles}
\title{Get Candlestick Data}
\usage{
candles(symbol = "AAPL", from = "2023-07-31", to = Sys.Date(), timeframe = 3)
}
\arguments{
\item{symbol}{Stock symbol to fetch candlestick data for.}

\item{from}{Starting date for the candlestick data in 'YYYY-MM-DD' format.}

\item{to}{Ending date for the candlestick data in 'YYYY-MM-DD' format.}

\item{timeframe}{Timeframe, min - 1, hour - 2, day - 3, week - 3, month - 5}
}
\value{
A data frame containing the candlestick data if the request was successful, NULL otherwise.
}
\description{
Retrieves historical candlestick data for a given stock symbol
within the specified date range. The API token is retrieved from
an environment variable 'LIMEX_API_TOKEN'.
}
\examples{
\dontrun{
  candles_data <- candles(symbol = "BRX", from = "2023-07-31", to = "2023-08-24")
}
}
