% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateVertex.R
\name{generateVertex}
\alias{generateVertex}
\title{Generates the new vertex of a simplex optimization}
\usage{
generateVertex(simplex, qflv = NULL, crit = "max", algor = "fixed",
  overwrite = FALSE)
}
\arguments{
\item{simplex}{object of class \code{smplx} with the simplex
information. See \code{\link{labsimplex}}}

\item{qflv}{response for the vertex (or vertexes) without responses}

\item{crit}{optimization criteria indicating if the goal is maximize
(\code{'max'}) or minimize (\code{'min'}) the response.
It can also be a numeric value to which the
response is supposed to approach}

\item{algor}{algorithm to be followed in the vertex generation.
\code{'fixed'} for a fixed step-size simplex
or \code{'variable'} for a variable step-size simplex}

\item{overwrite}{logical argument. If \code{TRUE}, the output simplex will
replace the one provided in the \code{simplex} parameter.
Default \code{overwrite = FALSE}}
}
\value{
An object of class \code{smplx} with the new simplex information
        including the conditions for the new experiment to be permormed.
}
\description{
Gives the coordinates for the new vertex that must be performed
based on the responses for the vertexes on the current simplex
and considering the optimization criteria.
}
\details{
When minimization is the criteria, the algorithm will tend to approach zero.
If negative responses are possible and the most negative value is desired,
a very large negative number must be provided in \code{crit} parameter.
}
\examples{
  simplex <- labsimplex(n = 3, centroid = c(320, 7, 0.4),
                        stepsize = c(35, 2, 0.3))
  ## The experiments must be performed and the responses passed to qflv.
  ## Here we get the responses by using an example response surface
  ## included in the package:
  ##
  ## Initially, the response must be provided for all the vertexes
  response <- exampleSurfaceR3(x1 = simplex$coords[, 1],
                               x2 = simplex$coords[, 2],
                               x3 = simplex$coords[, 3])
  simplex <- generateVertex(simplex = simplex, qflv = response)

  ## After this, the last vertex is the only one that must be evaluated
  response <- exampleSurfaceR3(x1 = simplex$coords[nrow(simplex$coords), 1],
                               x2 = simplex$coords[nrow(simplex$coords), 2],
                               x3 = simplex$coords[nrow(simplex$coords), 3])
  simplex <- generateVertex(simplex = simplex, qflv = response)

  ## Alternatively the simplex object can overwrite the older one:
  generateVertex(simplex = simplex, qflv = response, overwrite = TRUE)
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
