% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_translate.R
\name{check_arguments}
\alias{check_arguments}
\title{Function that applies some general checks to the arguments of \code{\link[=lama_translate]{lama_translate()}} and \code{\link[=lama_translate_]{lama_translate_()}}}
\usage{
check_arguments(.data, dictionary, col_new, keep_order, to_factor,
  err_handler)
}
\arguments{
\item{.data}{Either a data frame, a factor or an atomic vector.}

\item{dictionary}{A \link[=new_lama_dictionary]{lama_dictionary} object, holding the translations for various
variables.}

\item{col_new}{Only used if \code{.data} is a data frame. The argument \code{col} must be
a character vector of the same length as \code{translation} holding
the names under which the relabeled variables should be stored in
the data.frame. If omitted, then it will be assumed that the new column
names are the same as the column names of the original variables.}

\item{keep_order}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations. If the vector has
the same length as the number of arguments in \code{...}, then the
to each variable translation there is a corresponding boolean configuration.
If a translated variable in the data.frame is a factor variable,
and the corresponding boolean configuration is set to \code{TRUE}, then the
the order of the original factor variable will be preserved.}

\item{to_factor}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations. If the vector has
the same length as the number of arguments in \code{...}, then the
to each variable translation there is a corresponding boolean configuration.
If \code{to_factor} is \code{TRUE}, then the resulting labeled
variable will be a factor. If \code{to_factor} is set to \code{FALSE}, then
the resulting labeled variable will be a plain character vector.}

\item{err_handler}{An error handling function}
}
\description{
Function that applies some general checks to the arguments of \code{\link[=lama_translate]{lama_translate()}} and \code{\link[=lama_translate_]{lama_translate_()}}
}
