% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{use_backend}
\alias{use_backend}
\title{Configure a Keras backend}
\usage{
use_backend(backend, gpu = NA)
}
\arguments{
\item{backend}{string, can be \code{"tensorflow"}, \code{"jax"}, \code{"numpy"}, or
\code{"torch"}.}

\item{gpu}{bool, whether to use the GPU. If \code{NA} (default), it will
attempt to detect GPU availability on Linux. On macOS and Windows it
defaults to \code{FALSE}.}
}
\value{
Called primarily for side effects. Returns the provided
\code{backend}, invisibly.
}
\description{
Configure a Keras backend
}
\details{
These functions allow configuring which backend keras will use. Note that
only one backend can be configured at a time.

The function should be called after \code{library(keras3)} and before calling
other functions within the package (see below for an example).

Note that macOS packages like \code{tensorflow-metal} and \code{jax-metal} that
purportedly enabled GPU usage on M-series macs all are currently broken
and seemingly abandoned.

There is experimental support for changing the backend after keras has
initialized with \code{config_set_backend()}. Usage of \code{config_set_backend} is
generally not recommended for regular workflow---restarting the R session
is the only reliable way to change the backend.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(keras3)
use_backend("tensorflow")
}\if{html}{\out{</div>}}
}
