% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network_matrix.r
\name{get_network_matrix}
\alias{get_network_matrix}
\alias{get_network_matrix,pathway-method}
\title{Function to calculate the network \code{matrix} for a \code{\link{pathway}} object}
\usage{
\S4method{get_network_matrix}{pathway}(object, directed = TRUE, method = "auto")
}
\arguments{
\item{object}{A \code{\link{pathway}} object identifying the pathway for which gene interaction infomation should be extracted. Here, KEGG IDs of format 'hsa00100' are used and information is downloaded from the KEGG database.}

\item{directed}{A \code{logical} argument, stating whether the network matrix 
should return directed (\code{TRUE}) or undirected (\code{FALSE}) links.}

\item{method}{Download method to be used for downloading files, passed to via \code{KEGGgraph::retrieveKGML} to \code{utils::download.file} function. Currently supports \code{'auto'} (default), \code{'internal'}, \code{'wininet'} (Windows only), \code{'libcurl'}, \code{'wget'} and \code{'curl'}.}
}
\value{
\code{get_network_matrix} returns the modified \code{\link{pathway}} object, where the slots \code{adj} and \code{sign} are altered according to the downloaded information in the KEGG kgml file.
}
\description{
\code{get_network_matrix} creates the adjacency matrix representing the gene-gene interaction structure within a particular \code{\link{pathway}}. Note that a 
KEGG kgml file is downloaded and saved in the working directory.
}
\author{
Stefanie Friedrichs, Patricia Burger, Juliane Manitz
}
