% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerDataTwoGroupsByModelSelection.R
\name{centerDataTwoGroupsByModelSelection}
\alias{centerDataTwoGroupsByModelSelection}
\title{Center Each Column Based on Model Selection}
\usage{
centerDataTwoGroupsByModelSelection(X, group.one.indices,
  group.two.indices, within.group.indices)
}
\arguments{
\item{X}{a data matrix.}

\item{group.one.indices}{indices of observations in group one.}

\item{group.two.indices}{indices of observations in group two.}

\item{within.group.indices}{indices of columns on which to
perform group centering.}
}
\value{
Returns a centered data matrix of the same dimensions
as the original data matrix.
}
\description{
This function takes a data matrix and returns a centered data
matrix.  For columns with indices in \code{within.group.indices},
centering is performed by subtracting the corresponding
group mean from each entry (i.e. for entries in group one,
the group one mean is subtracted, and for entries in group two,
the group two mean is subtracted).  For other columns, global
centering is performed (i.e. subtracting the column mean from
each entry).
}
\details{
\bold{Example}
\preformatted{X <- matrix(1:12, nrow=4, ncol=3)
# Group center the first two columns, globally center
# the third column.
X.cen <- centerDataTwoGroupsByModelSelection(
  X, group.one.indices=1:2, group.two.indices=3:4,
  within.group.indices=1:2)
}
}
