% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_spectra.R
\name{itrax_spectra}
\alias{itrax_spectra}
\title{Import an individual spectra file}
\usage{
itrax_spectra(filename, parameters = "settings.dfl", plot = TRUE, datapos = 37)
}
\arguments{
\item{filename}{defines the name of the *.spe datafile from the core scanner to parse}

\item{parameters}{optionally defines a relevant Q-Spec settings file in order to compute the energy scale, otherwise channel numbers are reported}

\item{plot}{logical, if TRUE a side-plot is created}

\item{datapos}{defines the row at which spectral data begins in the files}
}
\value{
a tibble of the parsed data
}
\description{
Sometimes it is helpful to read an individual spectral file for diagnostics
}
\examples{
 itrax_spectra(filename   = system.file("extdata",
                                      "L000676.spe",
                                      package = "itraxR",
                                      mustWork = TRUE),
               parameters = system.file("extdata",
                                        "Results_settings.dfl",
                                        package = "itraxR",
                                        mustWork = TRUE)
               )

}
