% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_pairs.R
\docType{methods}
\name{ternary_pairs}
\alias{ternary_pairs}
\alias{ternary_pairs-method}
\alias{ternary_pairs,matrix-method}
\alias{ternary_pairs,data.frame-method}
\alias{ternary_pairs,data.frame,missing,missing-method}
\title{Ternary Plot Matrices}
\usage{
ternary_pairs(x, ...)

\S4method{ternary_pairs}{matrix}(x, margin = NULL, ...)

\S4method{ternary_pairs}{data.frame}(x, margin = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{matrix}} or a \code{\link{data.frame}}. Columns are converted to \code{numeric}
in the same way that \code{\link[=data.matrix]{data.matrix()}} does.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{margin}{A \code{\link{character}} string or an \code{\link{integer}} giving the index of
the column to be used as the third part of the ternary plots. If \code{NULL}
(the default), marginal compositions will be used (i.e. the geometric mean
of the non-selected parts).}
}
\value{
\code{ternary_pairs()} is called it for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Produces a matrix of ternary plots.
}
\examples{
## Data from Aitchison 1986
## Ternary plots with marginal compositions
ternary_pairs(boxite)

## Ternary plots with endite
ternary_pairs(boxite, margin = "E")
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_box}()},
\code{\link{ternary_grid}()},
\code{\link{ternary_plot}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
