% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsteps.R
\name{est_winsteps}
\alias{est_winsteps}
\title{Estimate Rasch Model using Winsteps}
\usage{
est_winsteps(
  x,
  target_dir = getwd(),
  analysis_name = "winsteps_analysis",
  items = NULL,
  examinee_id_var = NULL,
  additional_vars = NULL,
  anchor_info = NULL,
  overwrite = TRUE,
  winsteps_exe_folder = file.path("C:/Winsteps"),
  verbose = TRUE
)
}
\arguments{
\item{x}{A matrix or data frame that contains both response and person data.}

\item{target_dir}{The directory where the analysis results will be saved.
The default value is \code{getwd()}.}

\item{analysis_name}{A string that will be used for naming the files (data,
control, output) and as the title of the analysis. The default is
\code{"winsteps_analysis"}.}

\item{items}{A vector of strings representing item IDs within \code{x} to be
used as response data, or a numeric vector indicating the columns
containing response data. The default value is \code{NULL}, which uses all
columns in \code{x} except those specified in \code{examinee_id_var} and
\code{additional_vars}.}

\item{examinee_id_var}{A string representing the column name containing
examinee/subject IDs, or the column number of examinee/subject IDs. The
default value is \code{NULL}, assuming no examinee/subject IDs.}

\item{additional_vars}{A vector of strings or integers representing the
column names or numbers to be included in the Winsteps data file. The
default value is \code{NULL}, meaning no additional columns will be added
to the Winsteps data file. Note that if \code{items} is \code{NULL}, all
variables in the dataset will be treated as response data.}

\item{anchor_info}{A matrix or data frame containing the sequence number and
difficulty values of anchor items. The anchor matrix should have at least
two columns: (1) either \code{seq}, indicating the column numbers of the
anchor items in the response matrix, or \code{item_id} column containing
the IDs of anchor items, and (2) \code{b}, the item difficulty values. The
default value is \code{NULL}, meaning no anchor items are used.}

\item{overwrite}{A logical value. If \code{TRUE}, existing control/data files
will be overwritten. The default value is \code{TRUE}.}

\item{winsteps_exe_folder}{The directory containing the Winsteps executable.
The default value is \code{file.path("C:/Winsteps")}.}

\item{verbose}{If \code{TRUE}, the program will print intermediate steps.}
}
\description{
This function serves as an interface to the Winsteps program, allowing for
the convenient execution of basic Winsteps calibrations without the need to
write Winsteps syntax manually. Please note that a valid installation of
Winsteps is necessary for this function to operate. Keep in mind that it is
still in beta mode, so exercise caution when using it.
}
\examples{
\dontrun{
true_theta <- rnorm(300)
ip <- generate_ip(n = 20, model = "Rasch")
resp_set <- generate_resp_set(ip = ip, theta = true_theta, prop_missing = .2)
resp_matrix <- as.matrix(resp_set)

est_pars <- est_winsteps(x = resp_matrix,
                         target_dir = "c:/temp/est_winsteps")

# Relationship between true and estimated item difficulty parameters
plot(x = ip$b, y = est_pars$ip$b, xlab = "True 'b'", ylab = "Estimated 'b'")
cor(x = ip$b, y = est_pars$ip$b)

# Relationship between true and estimated theta parameters
cor(x = true_theta, y = est_pars$raw_person_pars$MEASURE)
plot(x = true_theta, y = est_pars$raw_person_pars$MEASURE,
     xlab = "True 'b'", ylab = "Estimated 'b'")
}
}
\author{
Emre Gonulates
}
