% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_plot.R
\name{plot.pk}
\alias{plot.pk}
\title{Plot a [pk()] object.}
\usage{
\method{plot}{pk}(
  x,
  newdata = NULL,
  model = NULL,
  method = NULL,
  use_scale_conc = FALSE,
  time_trans = FALSE,
  log10_C = NULL,
  plot_data_aes = NULL,
  plot_point_aes = NULL,
  facet_fun = NULL,
  facet_fun_args = NULL,
  drop_nonDetect = FALSE,
  plot_fit_aes = NULL,
  n_interp = 10,
  fit_limits = NULL,
  print_out = FALSE,
  best_fit = FALSE,
  ...
)
}
\arguments{
\item{x}{A [pk()] object. In this case `x` is used to align with generic method.}

\item{newdata}{Optional: A `data.frame` containing new data to plot. Must
contain at least variables `Chemical`, `Species`, `Route`, `Media`, `Dose`,
`Time`, `Time.Units`, `Conc`, `Detect`, `Conc_SD`.  Default `NULL`, to use
the data in `obj$data`.}

\item{model}{Character: One or more of the models fitted. Curve fits will be
plotted for these models. Default `NULL` to plot fits for all models in
`x$stat_model`.}

\item{method}{Character: One or more of the [optimx::optimx()] methods used.
Default `NULL` to plot fits for all methods in `x$pk_settings$optimx$method`.}

\item{use_scale_conc}{Possible values: `TRUE`, `FALSE`, or a named list with
elements `dose_norm` and `log10_trans` which themselves should be either
`TRUE` or `FALSE`.  If `use_scale_conc = FALSE` (the default for this
function), then the data and fits will be plotted without any
dose-normalization or log-transformation. If `use_scale_conc = TRUE` , then
the concentration scaling/transformations in `x` will be applied to the
y-axis (concentration axis). If `use_scale_conc = list(dose_norm = ...,
log10_trans = ...)`, then the specified dose normalization and/or
log10-transformation will be applied to the y-axis (concentration axis) of
the plots.}

\item{time_trans}{Default `FALSE`. Determines whether time values will be transformed.}

\item{log10_C}{Default `NULL`. Determines whether y-axis (concentration) should
be log10 transformed. Takes `TRUE` or `FALSE` values. Otherwise it defaults
to the value determined from `use_scale_conc`.}

\item{plot_data_aes}{Optional: Aesthetic mapping for the plot layer that
visualizes the data. Default `NULL`, in which case a default mapping will be
used based on the value of `use_scale_conc`.}

\item{plot_point_aes}{Optional: Aesthetic mappings for geom_point layer
that determines the fill of the points. Defaults to `NULL`.}

\item{facet_fun}{Default `"facet_grid"`. Optional: The name of the `ggplot2` faceting function to use:
[ggplot2::facet_grid()], [ggplot2::facet_wrap()], or `'none'` to do no
faceting. Default `NULL`, in which case a default faceting will be
applied based on the value of `use_scale_conc`.}

\item{facet_fun_args}{A named list of arguments to the faceting function in
 `facet_fun` (if any). Default:
```
list(rows = ggplot2::vars(Route),
cols= ggplot2::vars(Media),
scales = "free_y",
labeller = "label_both")
```}

\item{drop_nonDetect}{Default `FALSE`. Whether to eliminate observations below
the level of quantification (LOQ).}

\item{plot_fit_aes}{Optional: Aesthetic mapping for the plot layer that
visualizes the fitted curves. Default `NULL`, in which case a default mapping will be
used based on the value of `use_scale_conc`.}

\item{n_interp}{For plotting: the number of time points to interpolate between
each observed time point. Default 10.}

\item{fit_limits}{Default `NULL`. c(Upper Bound, Lower Bound).
Supply a numeric vector. These values filter the predicted
values for fits to not exceed 2.25x of the maximum observed concentration values
for each `data_group` in the `pk` object. When there is a log10 transformation
of concentration values, it limits predicted values to 1/20th of the minimum
observed concentration values and 5 times the maximum value.}

\item{print_out}{For plotting: whether the output of the function should be
the list of plots. Default `FALSE`.}

\item{best_fit}{Default FALSE. Determines whether fit plot outputs only the
best fit from `get_winning_model()`}

\item{...}{Additional arguments not in use.}
}
\value{
A [ggplot2::ggplot()]-class plot object.
}
\description{
Plot data and model fits from a [pk()] object.
}
\details{
If the [pk()] object has not been fitted, then only the data will be plotted
(because no curve fits exist).
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
