% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnorm_summary.R
\name{dnorm_summary}
\alias{dnorm_summary}
\title{Normal distribution density function for summary data}
\usage{
dnorm_summary(mu, sigma, x_mean, x_sd, x_N, log = FALSE)
}
\arguments{
\item{mu}{Mean of the normal distribution to be evaluated (*not* the sample
mean). May be a numeric scalar or vector.}

\item{sigma}{Standard deviation of the normal distribution to be evaluated
(*not* the sample SD). May be a numeric scalar or vector.}

\item{x_mean}{Sample mean. May be a numeric scalar or vector.}

\item{x_sd}{Sample standard deviation. May be a numeric scalar or vector.}

\item{x_N}{Sample number of observations. May be a numeric scalar or vector.}

\item{log}{TRUE/FALSE: Whether to return the log of the density function.
Default FALSE (to return the density function value on the natural scale).}
}
\value{
A numeric scalar or vector matching the length of the longest of
  `mu`, `sigma`, `x_mean`, `x_sd`, and `x_N`.
}
\description{
Evaluates the normal distribution density function for summary data reported
as sample mean, sample SD, and sample N.
}
\details{
`x_mean`, `x_sd`, `X_N`, `mu`, and `sigma` should either be all the same size, or length 1.
If they are different lengths, they will be repeated until their lengths
match, with a warning.
}
\author{
Caroline Ring
}
