% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_httk_gas_pbtk.R
\name{auc_httk_gas_pbtk}
\alias{auc_httk_gas_pbtk}
\title{Calculates AUC for `httk`'s `gas_pbtk` PBPK model}
\usage{
auc_httk_gas_pbtk(
  params,
  time,
  dose,
  route,
  medium = "plasma",
  this_chem = NULL,
  this_species = NULL,
  restrictive = TRUE
)
}
\arguments{
\item{params}{A named numeric vector of model parameter values.}

\item{time}{A numeric vector of times, reflecting the time point when
concentration is measured after the corresponding single bolus dose. Must be
same length as `dose` and `iv.dose`, or length 1.}

\item{dose}{A numeric vector of doses, reflecting single bolus doses
administered at time 0. Must be same length as `time` and `iv.dose`, or
length 1. In this model, it is expected that this value represents a measurement
of radioactive particles from a radiolabeling experiment.}

\item{route}{A character vector, reflecting the route of administration of
each single bolus dose: `'oral'` or `'iv'`.  Must be same length as `time`
and `dose`, or length 1.}

\item{medium}{A character vector reflecting the medium in which each resulting
concentration is to be calculated: "blood" or "plasma". Default is "plasma".
Must be same length as `time` and `dose`, or length 1.}

\item{this_chem}{A character vector naming the chemical for calculations in `httk`.}

\item{this_species}{A character vector naming the species for calculations in `httk`.}

\item{restrictive}{A logical value (TRUE or FALSE. Default: FALSE) that says whether the
assumption is that the clearance is restrictive or non-restrictive}
}
\value{
A vector of blood or plasma AUC values  corresponding
 to `time`.
}
\description{
Calculated plasma concentration AUC vs time according to the `gas_pbtk`
}
\section{Required parameters}{

These are given by [httk::parameterize_gas_pbtk()].
Furthermore, they are transformed to a vector during the prefitting process.
The optimized parameters are `Clint` and `Funbound.plasma`. Because
these optimized parameters impact `Clmetabolismc`, `Krbc2pu`, `Rblood2plasma`
and `Fabsgut`, these are recalculated at the beginning of this function.
}

\seealso{
Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_params_httk_gas_pbtk}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{get_starts_httk_gas_pbtk}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}

Other httk model functions: 
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_httk_gas_pbtk}()},
\code{\link{get_starts_httk_gas_pbtk}()}
}
\author{
Gilberto Padilla Mercado
}
\concept{built-in model functions}
\concept{httk model functions}
\concept{model auc functions}
