% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hibrid_normal.R
\name{Hibrid_normal}
\alias{Hibrid_normal}
\title{Hibrid_normal}
\usage{
Hibrid_normal(
  demand,
  mean,
  sd,
  leadtime,
  service_level,
  Review_period,
  min = FALSE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.}

\item{sd}{standard deviation in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Review_period}{the period where the ordering happens.}

\item{min}{min quantity for order up to level,if FALSE, then calculated automatically.}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}

\item{ordering_cost}{ordering cost for every time an order is made.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Hibrid Policy normal distribution service level,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and 
requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated.
 the order up to level is calculated based on the review period,lead time and normal distribution.
 Inventory is replenished if inventory position is below min or it is time for review period.
}
\examples{

Hibrid_normal(demand=rpois(80,6),mean=4,sd=0.2,leadtime=5,service_level=0.95,
Review_period =9,min=30,
shortage_cost= FALSE,inventory_cost=FALSE,ordering_cost=FALSE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
