% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvi.R
\name{allocateCVI}
\alias{allocateCVI}
\title{Allocate sequences for cross validation by identity.}
\usage{
allocateCVI(x, threshold = 0.9, allocate = "max", ...)
}
\arguments{
\item{x}{a set of reference sequences. Can be a
"DNAbin" object or a named vector of upper-case DNA character strings.}

\item{threshold}{numeric between 0 and 1 giving the identity threshold for sequence allocation.}

\item{allocate}{character giving the method to use to allocate eligible sequences to the query set.
Options are "max" (default) which chooses the largest node from each pair in order to
maximize the size of the query set,
or "sample", which randomly chooses one node from each eligible pair.}

\item{...}{further arguments to pass to "kmeans"}
}
\value{
a logical vector the same length as the input object, indicating which sequences
  should be allocated to the query set
}
\description{
This function takes a reference sequence database and allocates each sequence to either
  a query set (a.k.a. test set) or a training set, in order to cross validate a
  supervised taxon classifier. The method is based on that of Edgar (2018), but uses
  recursive divisive clustering and retains all sequences rather than discarding those that
  violate the top-hit identity constraint.
}
\examples{
\donttest{
  data(whales)
  allocateCVI(whales)
}
}
\references{
Edgar RC (2018) Accuracy of taxonomy prediction for 16S rRNA and fungal ITS sequences.
  PeerJ 6:e4652. DOI 10.7717/peerj.4652
}
\author{
Shaun Wilkinson
}
