% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/except.R
\name{except}
\alias{except}
\alias{tryExcept}
\alias{\%except\%}
\title{Simple Error Handling}
\usage{
tryExcept(expr, except = { }, error = function(e) { })

expr \%except\% except
}
\arguments{
\item{expr}{Expression to be evaluated.}

\item{except}{Expression to be evaluated if \code{expr} raises an error. By default it is
an empty expression.}

\item{error}{Handler function for an \code{error} condition occurred during the evaluation
of \code{expr}. It's output is not used, as the output in case of an error is the
evaluation of \code{except}. By default it is an empty function.}
}
\description{
Use this method to handle errors. The function evaluates an expression,
    and if it raises an error then evaluates a second expression.
}
\details{
\code{tryExcept} is a wrapper around \code{\link[base]{tryCatch}},
    but it allows you to evaluate an expression \code{except} when an error occurs to
    the first expression argument \code{expr}. Note that, if \code{expr} raises
    an error, the code evaluated before the error will be in use.
}
\examples{
# No errors are raised
tryExcept(stop())

# If 'expr' has no errors
tryExcept({
  foo <- "foo"
}, except = {
  foo <- "foo bar"
})
print(foo) # "foo"

# If 'expr' has an error
tryExcept({
  foo <- "foo"
  stop()
}, except = {
  foo <- "foo bar"
})
print(foo) # "foo bar"

# Running it with the infix operator
{foo <- "foo"} \%except\% {foo <- "foo bar"}
print(foo) # "foo"

{ foo <- "foo"
  stop()
} \%except\% {
  foo <- "foo bar"
}
print(foo) # "foo bar"
}
