% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{dGompertzNorm}
\alias{dGompertzNorm}
\title{density for Gompertz transformed univariate Gaussian}
\usage{
dGompertzNorm(x, mu, sigma)
}
\arguments{
\item{x, }{numeric real}

\item{mu, }{numeric real}

\item{sigma, }{numeric real positive}
}
\value{
tranformed density on support (0, 1)
}
\description{
density for Gompertz transformed univariate Gaussian
}
\examples{
mu <- -1
sigma <- 1
z <- rnorm(10000, mu, sigma)
hist(1 - exp(-exp(z)), freq = FALSE)
curve(dGompertzNorm(x, mu = mu, sigma = sigma), col = 'red', add = TRUE, from = 0.01, to = 0.99)
integrate(function(x) dGompertzNorm(x, mu = mu, sigma = sigma), lower = 0, upper = 1) # equals 1
}
