% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMLH.R
\name{sMLH}
\alias{sMLH}
\title{Calculate multilocus heterozygosity (MLH)}
\usage{
sMLH(genotypes)
}
\arguments{
\item{genotypes}{data.frame with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and \code{NA} (missing)}
}
\value{
Vector of individual standardized multilocus heterozygosities
}
\description{
sMLH is defined as the total number of heterozygous loci in an individual divided 
by the sum of average observed heterozygosities in the population over the 
subset of loci successfully typed in the focal individual.
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
het <- sMLH(genotypes)

}
\references{
Coltman, D. W., Pilkington, J. G., Smith, J. A., & Pemberton, J. M. (1999). 
Parasite-mediated selection against inbred Soay sheep in a free-living, 
island population. Evolution, 1259-1267.
}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
