% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{xts_df}
\alias{xts_df}
\title{Convert xts to data.frame}
\usage{
xts_df(x, keep.attrs = FALSE)
}
\arguments{
\item{x}{an \sQuote{xts} object.}

\item{keep.attrs}{[default FALSE] if set to TRUE, will preserve any custom
attributes set on the original object.}
}
\value{
A \sQuote{data.frame} object. The \sQuote{xts} index is preserved as
    the first column with header \sQuote{index}.
}
\description{
An optimised 'xts' to 'data.frame' constructor.
}
\details{
The optimised data.frame constructors are used internally within
    the package and made available as utilities. Please note that no data
    validation or checking is performed.
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
df <- xts_df(cloud)
str(df)

df2 <- xts_df(cloud, keep.attrs = TRUE)
str(df2)

}
