% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iscca.R
\name{iscca}
\alias{iscca}
\title{Integrative sparse canonical correlation analysis}
\usage{
iscca(x, y, L, mu1, mu2, mu3, mu4, eps = 1e-04, pen1 = "homogeneity",
  pen2 = "magnitude", scale.x = TRUE, scale.y = TRUE, maxstep = 50,
  submaxstep = 10, trace = FALSE, draw = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{mu1}{numeric, sparsity penalty parameter for vector u.}

\item{mu2}{numeric, contrasted penalty parameter for vector u.}

\item{mu3}{numeric, sparsity penalty parameter for vector v.}

\item{mu4}{numeric, contrasted penalty parameter for vector v.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{pen1}{character, "homogeneity" or "heterogeneity" type of the sparsity structure. If not specified, the default is homogeneity.}

\item{pen2}{character, "magnitude" or "sign" based contrasted penalty. If not specified, the default is magnitude.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{submaxstep}{numeric, maximum iteration steps in the sub-iterations. The default value is 10.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}

\item{draw}{character, "TRUE" or "FALSE". If TRUE, plot the convergence path of loadings and the heatmap of coefficient beta.}
}
\value{
An 'iscca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{loading.x:}{ the estimated canonical vector of variables x.}
\item{loading.y:}{ the estimated canonical vector of variables y.}
\item{variable.x:}{ the screening results of variables x. }
\item{variable.y:}{ the screening results of variables y.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
This function provides a penalty-based integrative sparse canonical correlation analysis method to handle the multiple datasets with high dimensions generated under similar protocols, which consists of two built-in penalty items for selecting the important variables for users to choose, and two contrasted penalty functions for eliminating the diffierence (magnitude or sign) between estimators within each group.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.cca")
x <- simData.cca$x
y <- simData.cca$y
L <- length(x)
mu1 <- mu3 <- 0.4
mu2 <- mu4 <- 2.5

prev_cca <- preview.cca(x = x, y = y, L = L, scale.x = TRUE, scale.y = TRUE)
res_homo_m <- iscca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, mu3 = mu3, mu4 = mu4,
                    eps = 5e-2, maxstep = 50, submaxstep = 10, trace = TRUE, draw = TRUE)

\donttest{
res_homo_s <- iscca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, mu3 = mu3, mu4 = mu4,
                    eps = 5e-2, pen1 = "homogeneity", pen2 = "sign", scale.x = TRUE,
                    scale.y = TRUE, maxstep = 50, submaxstep = 10, trace = FALSE, draw = FALSE)

mu1 <- mu3 <- 0.3
mu2 <- mu4 <- 2
res_hete_m <- iscca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, mu3 = mu3, mu4 = mu4,
                    eps = 5e-2, pen1 = "heterogeneity", pen2 = "magnitude", scale.x = TRUE,
                    scale.y = TRUE, maxstep = 50, submaxstep = 10, trace = FALSE, draw = FALSE)

res_hete_s <- iscca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, mu3 = mu3, mu4 = mu4,
                    eps = 5e-2, pen1 = "heterogeneity", pen2 = "sign", scale.x = TRUE,
                    scale.y = TRUE, maxstep = 50, submaxstep = 10, trace = FALSE, draw = FALSE)
}
}
\seealso{
See Also as \code{\link{preview.cca}}, \code{\link{iscca.cv}}, \code{\link{meta.scca}}, \code{\link{scca}}.
}
