% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.NormalIG.Hierarchical.R
\name{sim.NormalIG.Hierarchical.config}
\alias{sim.NormalIG.Hierarchical.config}
\title{Create a configuration object for the sim.NormalIG.Hierarchical function}
\usage{
sim.NormalIG.Hierarchical.config(
  nR = 5,
  nC = 100,
  modalityID = c("testA", "testA*"),
  C_dist = "normal",
  mu = 0,
  tau_A = 0,
  tau_B = 0,
  alpha_R = 10,
  beta_R = 1,
  sigma_C = 1,
  a_C = 0.8,
  b_C = 3,
  sigma_tauC = 1,
  alpha_tauR = 10,
  beta_tauR = 1,
  C_scale = 1,
  RC_scale = 1,
  tauC_scale = 1,
  tauRCE_scale = 1
)
}
\arguments{
\item{nR}{[num] Number of readers. Default \code{nR = 5}}

\item{nC}{[num] Number of cases. Default \code{nC = 100}}

\item{modalityID}{[vector] List of modalityID. Default \code{modalityID = c("testA", "testA*")}}

\item{C_dist}{[chr] Distribution of the case. Default \code{C_dist="normal"}}

\item{mu}{[num] grand mean. Default \code{mu = 0}}

\item{tau_A}{[num] modality A effect. Default \code{tau_A = 0}}

\item{tau_B}{[num] modality B effect. Default \code{tau_B = 0}}

\item{alpha_R}{[num] shape parameter for reader. Default \code{alpha_R = 10}}

\item{beta_R}{[num] scale parameter for reader. Default \code{beta = 1}}

\item{sigma_C}{[num] std of case factor (if \code{C_dist="normal"}). Default \code{sigma_C = 1}}

\item{a_C}{[num] alpha for distribution of case (if \code{C_dist="beta"}). Default \code{a_C = 0.8}}

\item{b_C}{[num] beta for distribution of case (if \code{C_dist="beta"}). Default \code{b_C = 3}}

\item{sigma_tauC}{[num] std of modality-case (if \code{C_dist="normal"}). Default \code{sigma_tauC = 1}}

\item{alpha_tauR}{[num] shape parameter for modality-reader. Default \code{alpha_tauR = 10}}

\item{beta_tauR}{[num] scale parameter for modality-reader. Default \code{beta_tauR = 1}}

\item{C_scale}{[num] weight for the case factor. Default \code{C_scale = 1}}

\item{RC_scale}{[num] weight for the reader-case interaction term. Default \code{RC_scale = 1}}

\item{tauC_scale}{[num] weight for the modality-case term. Default \code{tauC_scale = 1}}

\item{tauRCE_scale}{[num] weight for the modality-reader-case-replicate interaction term. Default \code{tauRCE_scale = 1}}
}
\value{
config [list] of input parameters for \code{\link{sim.NormalIG.Hierarchical}}.
}
\description{
This function creates a configuration object that sets the parameters
for the Hierarchical Inverse-Gamma simulation model. The configuration
object is an to the \code{\link{sim.NormalIG.Hierarchical}} function.
}
\details{
If no arguments, this function returns a default simulation
configuration for the \code{\link{sim.NormalIG.Hierarchical}} function.
}
