#' Auxiliary Internal Functions
#'
#' @rdname n_elecfuns
#' @param x Numeric vector 
#'
#' @return The maximum of a vector, after removing non-finite elements
#'
#' 
#' 
max_ninf <- function(x){
  if(any(is.infinite(x))){
    if(all(!is.finite(x)) | all(is.na(x))){
      return(-Inf)
    } else {
      return(max(x[-which(is.infinite(x))], na.rm=TRUE))
    }
  } else {
    return(max(x, na.rm=TRUE))
  }
}