% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swe_to_melt.R
\name{swe_to_melt}
\alias{swe_to_melt}
\title{Snow water equivalent to melt}
\usage{
swe_to_melt(df)
}
\arguments{
\item{df}{data frame with 'swe' serie in the second column. See \code{'read_XXX'} functions.}
}
\value{
Data frame containing the numeric vector with melted snow.
}
\description{
Converts a snow water equivalent series (from snow pillow) into a melt series.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Read swe sheet
toscas_swe <- read_DGI(file = 'Toscas.xlsx', sheet = 'swe',
                colName = 'swe(mm)', path = full_path)

# swe to melt
toscas_melt <- swe_to_melt(df = toscas_swe)               
                
}
