% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_threshold.R
\name{set_threshold}
\alias{set_threshold}
\title{Set a threshold}
\usage{
set_threshold(x, threshold, case = ">=")
}
\arguments{
\item{x}{numeric vector or data frame with a numeric series in the second column.}

\item{threshold}{numeric value with threshold.}

\item{case}{string with either '>=' (greater or equal than) or '<=' (lesser or equal than) symbol.}
}
\value{
Numeric vector or data frame with values greater (or lesser) or equal than 'threshold' set as \code{NA_real_}.
}
\description{
Set tolerable extreme values (maximum or minimum). Records greater or equal than ('>=') or lesser or equal than ('<=') 'threshold' argument are set to \code{NA_real_}.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Read IANIGLA file
cuevas <- read_IANIGLA(file = 'Cuevas.csv', path = full_path)             

# Set threshold from air temperature series
tair_thres <- set_threshold(x = cuevas, threshold = 40)

}
