% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_set_hydroMet.R
\name{set_hydroMet}
\alias{set_hydroMet}
\alias{set_hydroMet,hydroMet-method}
\alias{set_hydroMet,hydroMet_BDHI-method}
\alias{set_hydroMet,hydroMet_DGI-method}
\alias{set_hydroMet,hydroMet_IANIGLA-method}
\alias{set_hydroMet,hydroMet_CR2-method}
\alias{set_hydroMet,hydroMet_compact-method}
\title{Set the data of an \code{hydroMet} object or its subclasses}
\usage{
set_hydroMet(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  ...
)

\S4method{set_hydroMet}{hydroMet}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL
)

\S4method{set_hydroMet}{hydroMet_BDHI}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  Qmd = NULL,
  Qmm = NULL,
  precip = NULL,
  tdb = NULL,
  tmax = NULL,
  tmin = NULL,
  swe = NULL,
  hr = NULL,
  wspd = NULL,
  wdir = NULL,
  evap = NULL,
  anem = NULL,
  patm = NULL
)

\S4method{set_hydroMet}{hydroMet_DGI}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  swe = NULL,
  tmean = NULL,
  tmax = NULL,
  tmin = NULL,
  hr = NULL,
  patm = NULL,
  hsnow = NULL
)

\S4method{set_hydroMet}{hydroMet_IANIGLA}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  date = NULL,
  tair = NULL,
  hr = NULL,
  patm = NULL,
  precip = NULL,
  wspd = NULL,
  wdir = NULL,
  kin = NULL,
  hsnow = NULL,
  tsoil = NULL,
  hwat = NULL
)

\S4method{set_hydroMet}{hydroMet_CR2}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  precip = NULL,
  tmean = NULL,
  tmax = NULL,
  tmin = NULL
)

\S4method{set_hydroMet}{hydroMet_compact}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  compact = NULL
)
}
\arguments{
\item{obj}{an \code{hydroMet} or \code{hydroMet_XXX} class object.}

\item{id}{numeric. This is the ID assigned by the agency.}

\item{agency}{character. The name of the agency (or institution) that provides the data of the station.}

\item{station}{character. The name of the (hydro)-meteorological station.}

\item{lat}{numeric. Latitude of the station.}

\item{long}{numeric. Longitude of the station}

\item{alt}{numeric. Altitute of the station.}

\item{country}{character. Country where the station is located. Argentina is set as default value.}

\item{province}{character. Name of the province where the station is located. Mendoza is set as default value.}

\item{river}{character. Basin river's name.}

\item{active}{logical. It indicates whether or not the station is currently operated. Default value is \code{TRUE}.}

\item{...}{arguments to be passed to methods. They rely on the slots of the \code{obj} subclass.}

\item{Qmd}{daily mean river discharge.}

\item{Qmm}{monthly mean river discharge.}

\item{precip}{precipitation.}

\item{tdb}{dry bulb temperature.}

\item{tmax}{daily maximum air temperature.}

\item{tmin}{daily minimum air temperature.}

\item{swe}{snow water equivalent.}

\item{hr}{relative humidity.}

\item{wspd}{wind speed.}

\item{wdir}{wind direction.}

\item{evap}{evaporation.}

\item{anem}{wind speed above the pan-evaporation.}

\item{patm}{atmospheric pressure.}

\item{tmean}{daily mean air temperature.}

\item{hsnow}{snow height.}

\item{date}{time serie with dates.}

\item{tair}{air temperature.}

\item{kin}{incoming shortwave radiation.}

\item{tsoil}{soil temperature.}

\item{hwat}{stream water level.}

\item{compact}{data frame with Date as first column. All other columns are hydro-meteorological variables.}
}
\value{
The hydroMet object with the slots setted.
}
\description{
With this method you can set (or change) an specific slot value.
}
\section{Functions}{
\itemize{
\item \code{set_hydroMet,hydroMet-method}: set method for generic object

\item \code{set_hydroMet,hydroMet_BDHI-method}: set method for BDHI object

\item \code{set_hydroMet,hydroMet_DGI-method}: set method for DGI object

\item \code{set_hydroMet,hydroMet_IANIGLA-method}: set method for IANIGLA object

\item \code{set_hydroMet,hydroMet_CR2-method}: set method for CR2 object

\item \code{set_hydroMet,hydroMet_compact-method}: set method for \code{compact} object
}}

\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# Assign altitude
guido <- set_hydroMet(obj = guido, alt = 2480)

}
