% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_spikes.R
\name{rm_spikes}
\alias{rm_spikes}
\title{Remove spikes}
\usage{
rm_spikes(df, tolerance)
}
\arguments{
\item{df}{data frame with date and numeric variable in the first and second column respectively (from \code{read_XXX} functions).}

\item{tolerance}{numeric with maximum tolerance between a number and its successor.}
}
\value{
The same data frame but without peaks.
}
\description{
Removes spikes, and sets their value to \code{NA_real_}.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Read IANIGLA file
cuevas <- read_IANIGLA(file = 'Cuevas.csv', path = full_path)             

# Remove spikes from air temperature series
tair_rm_spikes <- rm_spikes(df = cuevas, tolerance = 10)

}
