% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_IANIGLA.R
\name{read_IANIGLA}
\alias{read_IANIGLA}
\title{Reads data provided by IANIGLA}
\usage{
read_IANIGLA(file, all = FALSE, path = NULL)
}
\arguments{
\item{file}{string with the name of the '.csv' file downloaded from the meteo-stations web page.}

\item{all}{logical value indicating whether the returned data frame contain all the original columns or just the date and data.}

\item{path}{string with the files directory. If not provided, the function will use the current working directory.}
}
\value{
A data frame containing the hourly data measured by the automatic weather stations. Gaps between dates are filled with NA_real_ and duplicated rows are eliminated automatically.
}
\description{
Reads the data provided by IANIGLA (Instituto Argentino de Nivologia, Glaciologia y Ciencias Ambientales).
}
\note{
In this package version we only provide functionality for a specific data-set generated in the institute.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Apply function
cuevas <- read_IANIGLA(file = 'Cuevas.csv', path = full_path)             

}
