% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_convergence.R
\name{check_convergence}
\alias{check_convergence}
\title{Check Convergence for a Regression Model}
\usage{
check_convergence(
  data,
  exposures,
  outcome,
  approach = "logit",
  multivariate = FALSE
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{exposures}{A character vector of predictor variable names.
If \code{multivariate = FALSE}, each exposure is assessed separately.
If \code{multivariate = TRUE}, exposures are included together.}

\item{outcome}{A character string specifying the outcome variable.}

\item{approach}{A character string specifying the regression approach.
One of:
  \code{"logit"}, \code{"log-binomial"}, \code{"poisson"},
  \code{"robpoisson"}, or \code{"negbin"}.}

\item{multivariate}{Logical. If \code{TRUE},
checks convergence for a multivariable model;
  otherwise, performs checks for each univariate model.}
}
\value{
A data frame summarizing convergence diagnostics, including:
\describe{
  \item{\code{Exposure}}{Name of the exposure variable.}
  \item{\code{Model}}{The regression approach used.}
  \item{\code{Converged}}{\code{TRUE} if the model converged successfully;
   \code{FALSE} otherwise.}
  \item{\code{Max.prob}}{Maximum predicted probability or
  fitted value in the dataset.}
}
}
\description{
Assesses model convergence and provides diagnostics
for each exposure (in univariate mode) or
for the full model (in multivariable mode),
depending on the regression approach used.
}
\details{
For \code{robpoisson}, predicted probabilities (fitted values) may exceed 1,
which is acceptable when estimating risk ratios but should not be interpreted
as actual probabilities.

This function is useful for identifying convergence issues, especially for
\code{"log-binomial"} models, which often fail to converge .
}
\examples{
if (requireNamespace("gtregression", quietly = TRUE)) {
  data(data_PimaIndiansDiabetes, package = "gtregression")

  check_convergence(
    data = data_PimaIndiansDiabetes,
    exposures = c("age", "bmi"),
    outcome = "diabetes",
    approach = "logit"
  )

  check_convergence(
    data = data_PimaIndiansDiabetes,
    exposures = c("age", "bmi"),
    outcome = "diabetes",
    approach = "logit",
    multivariate = TRUE
  )
}
}
\seealso{
[identify_confounder()],  [interaction_models()]
}
