% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blinded_ssr.R
\name{blinded_ssr}
\alias{blinded_ssr}
\title{Blinded sample size re-estimation for recurrent events}
\usage{
blinded_ssr(
  data,
  ratio = 1,
  lambda1_planning,
  lambda2_planning,
  rr0 = 1,
  power = 0.8,
  alpha = 0.025,
  method = "friede",
  accrual_rate,
  accrual_duration,
  trial_duration,
  dropout_rate = 0,
  max_followup = NULL,
  event_gap = NULL
)
}
\arguments{
\item{data}{A data frame containing the blinded interim data. Must include
columns \code{events} (number of events) and \code{tte} (total exposure/follow-up time).
This is typically the output of \code{\link[=cut_data_by_date]{cut_data_by_date()}}.}

\item{ratio}{Planned allocation ratio (experimental / control). Default is 1.}

\item{lambda1_planning}{Planned event rate for the control group used in original calculation.}

\item{lambda2_planning}{Planned event rate for the experimental group used in original calculation.}

\item{rr0}{Rate ratio under the null hypothesis (lambda2/lambda1). Default is 1.}

\item{power}{Target power (1 - beta). Default is 0.8.}

\item{alpha}{One-sided significance level. Default is 0.025.}

\item{method}{Method for sample size recalculation. Currently "friede" (Friede & Schmidli 2010)
is implemented, which uses the blinded nuisance parameter estimates.}

\item{accrual_rate}{Vector of accrual rates (patients per unit time).}

\item{accrual_duration}{Vector of durations for each accrual rate. Must be same length
as \code{accrual_rate}.}

\item{trial_duration}{Total planned duration of the trial.}

\item{dropout_rate}{Dropout rate (hazard rate). Default is 0.}

\item{max_followup}{Maximum follow-up time for any patient. Default is NULL (infinite).}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Default is NULL (no gap).}
}
\value{
A list containing:
\describe{
\item{n_total_blinded}{Re-estimated total sample size using blinded estimates.}
\item{dispersion_blinded}{Estimated dispersion parameter (k) from blinded data.}
\item{lambda_blinded}{Estimated overall event rate from blinded data.}
\item{info_fraction}{Estimated information fraction at interim (blinded information / target information).}
\item{blinded_info}{Estimated statistical information from the blinded interim data.}
\item{target_info}{Target statistical information required for the planned power.}
}
}
\description{
Estimates the blinded dispersion and event rate from aggregated interim data
and calculates the required sample size to maintain power, assuming the
planned treatment effect holds. This function supports constant rates
(Friede & Schmidli 2010) and accommodates future extensions for time-varying
rates (Schneider et al. 2013) by using the exposure-adjusted rate.
}
\examples{
interim <- data.frame(events = c(1, 2, 1, 3), tte = c(0.8, 1.0, 1.2, 0.9))
blinded_ssr(
  interim,
  ratio = 1,
  lambda1_planning = 0.5,
  lambda2_planning = 0.3,
  power = 0.8,
  alpha = 0.025,
  accrual_rate = 10,
  accrual_duration = 12,
  trial_duration = 18
)
}
\references{
Friede, T., & Schmidli, H. (2010). Blinded sample size reestimation with
count data: methods and applications in multiple sclerosis.
\emph{Statistics in Medicine}, 29(10), 1145--1156. \doi{10.1002/sim.3861}

Schneider, S., Schmidli, H., & Friede, T. (2013). Blinded sample size
re-estimation for recurrent event data with time trends.
\emph{Statistics in Medicine}, 32(30), 5448--5457. \doi{10.1002/sim.5977}
}
